-- Messaging for Buzz Applicant Appointment Event (Valencia Sprint)

SET @systemmsgeventId=(SELECT MAX(id) FROM system_msg_event);
SET @msgSubCategoryId=(SELECT id FROM msg_category WHERE `code`='APPOINTMENT');
INSERT INTO `system_msg_event` 
(`id`, `msgConfigLevelId`, `msgSubCategoryId`, `code`, `displayCode`, `eventType`, `whetherRepetationApplicable`, `whetherInitiationRuleApplicable`, `whetherScheduledEvent`, `whetherMsgScopeApplicable`, `whetherImplicitDistributionList`, `whetherDistributionRuleApplicable`, `whetherCommonMsgTemplate`, `description`,`uiDisplayCode`) 
VALUES (@systemmsgeventId+1, '1', @msgSubCategoryId, 'BUZZ_APPLICANT_APPOINTMENT', 'Buzz Applicant Appointment', 'SYSTEM', 0, 0, 0, 0, 1, 0, 0, 'Buzz Applicant Appointment','Buzz Applicant Appointment');


SET @sysmsgevtdefaultconfId=(SELECT MAX(id) FROM sys_msg_evt_default_conf);
INSERT INTO `sys_msg_evt_default_conf` (`id`, `systemMsgEventId`, `msgTemplateConfigId`, `initiationRuleProviderId`, `sendingPriority`) 
VALUES (@sysmsgevtdefaultconfId+1, @systemmsgeventId+1, NULL, NULL, 'IMMEDIATE');


SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONTEXT_RECORD_ID');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);


SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EVENT_TRIGGER_DATE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='ACADEMY_LOCATION_IDS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EXTRA_PARAMS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

-- Template data provider for the Appointment

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'BUZZ_APPLICANT_APPOINTMENT_DL', 'SQL');

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'BUZZ_APPLICANT_APPOINTMENT_RECIPIENT', 'SQL');

SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='BUZZ_APPLICANT_APPOINTMENT_RECIPIENT');
INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) VALUES (@msgRecipientId+1, @dtproviderId, 'BUZZ_APPLICANT_APPOINTMENT_RECIPIENT');


SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='BUZZ_APPLICANT_APPOINTMENT_DL');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='BUZZ_APPLICANT_APPOINTMENT_RECIPIENT');
INSERT INTO `sys_msg_evtrcpt_default_conf` (`id`, `sysMsgEvtDefaultConfId`, `distrListProviderId`, `distrRuleProviderId`, `recipientTypeId`) 
VALUES (@sysmsgevtrcptdefaultconfId+1, @sysmsgevtdefaultconfId+1, @dtproviderId, NULL, @recipientTypeId);



-- Setting the query for the Applicant distribution list

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='BUZZ_APPLICANT_APPOINTMENT_DL');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId, "select T1.id as USER_ID from sg_appointment T1 where T1.id in(namedParams)",NULL);


-- Setting the query for the User Recipient

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='BUZZ_APPLICANT_APPOINTMENT_RECIPIENT');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,
"SELECT 
    sg.id AS ID,
    T1.code AS APPLICANT_CODE,
    sg.appointeeName AS APPOINTEE_PRINT_NAME,
    sg.appointeeEmailId AS APPOINTEE_EMAIL_ID,
    DATE_FORMAT(sg.visitTime, '%h:%i %p') AS VISIT_TIME,
    DATE_FORMAT(sg.appointmentDate, '%d-%m-%Y') AS APPOINTMENT_DATE,
    TRIM(SUBSTRING_INDEX(personToMeet, '/', - 1)) AS PERSON_TO_MEET,
    T4.academyName AS ACADEMY_NAME,
    T4.locationName AS LOCATION_NAME,
    T4.displayName AS ACADEMY_NAME_LOCATION,
    T2.`emailId` AS EMAIL_ID,
    T2.`mobileNumber` AS MOBILE_NO,
    T2.`mobileCountryCode` AS MOBILE_CODE,
    T2.`firstName` AS FIRST_NAME,
    T2.`lastName` AS LAST_NAME,
    T15.`programNameToBePrint` AS PROGRAM_NAME,
    T14.`printName` AS BATCH_PRINT_NAME,
    T16.`seatName` AS SEAT_TYPE,
    CONCAT(T6.addressText,' ',T7.cityName,', ',T8.countryName,', ',T9.countryRegionName) AS ACADEMY_LOCATION_ADDRESS,
    CONCAT(T6.phoneCountryCode, '-',T6.phoneAreaCode,'-', T6.phoneNo) AS ACADEMY_LOCATION_PHONE_NO,
    T6.primaryeEmailId AS ACADEMY_LOCATION_EMAIL_ID,
    T6.websiteURL AS ACADEMY_LOCATION_URL,
    T10.printName OWNER_NAME,
    (CASE
        WHEN
            T1.currentStatus IS NOT NULL
                AND T1.currentStatus = 'APPLIED'
        THEN
            'Applied'
        WHEN
            T1.currentStatus IS NOT NULL
                AND T1.currentStatus = 'NOT_APPLIED'
        THEN
            'Not Applied'
        WHEN
            T1.currentStatus IS NOT NULL
                AND T1.currentStatus = 'SOLD'
        THEN
            'Sold'
        WHEN
            T1.currentStatus IS NOT NULL
                AND T1.currentStatus = 'SUBMITTED'
        THEN
            'Submitted'
        WHEN
            T1.currentStatus IS NOT NULL
                AND T1.currentStatus = 'APPROVED'
        THEN
            'Approved'
        WHEN
            T1.currentStatus IS NOT NULL
                AND T1.currentStatus = 'REJECTED'
        THEN
            'Rejected'
        WHEN
            T1.currentStatus IS NOT NULL
                AND T1.currentStatus = 'WITHDRAWN'
        THEN
            'Withdrawn'
        WHEN
            T1.currentStatus IS NOT NULL
                AND T1.currentStatus = 'CLOSED'
        THEN
            'Closed'
        WHEN
            T1.currentStatus IS NOT NULL
                AND T1.currentStatus = 'DIRECT_ADMISSION'
        THEN
            'Direct Admission'
        WHEN
            T1.currentStatus IS NOT NULL
                AND T1.currentStatus = 'MID_TERM_ADMISSION'
        THEN
            'Mid term admission'
        WHEN
            T1.currentStatus IS NOT NULL
                AND T1.currentStatus = 'DIRECT_SUBMISSION_TOKEN_GENERATED'
        THEN
            'Direct submission token generated'
        WHEN
            T1.currentStatus IS NOT NULL
                AND T1.currentStatus = 'FORM_SALE_TOKEN_GENERATED'
        THEN
            'Form sale token generated'
        WHEN
            T1.currentStatus IS NOT NULL
                AND T1.currentStatus = 'NOT_SUBMITTED'
        THEN
            'Not Submitted'
        WHEN
            T1.currentStatus IS NOT NULL
                AND T1.currentStatus = 'ADMISSION_GRANTED'
        THEN
            'Admission granted'
        ELSE ''
    END) AS APPLICATION_STATUS,
    (CASE
        WHEN
            T11.currentStatus IS NOT NULL
                AND T11.currentStatus = 'OFFER_LETTER_ACCEPTED'
        THEN
            'Offer letter accepted'
        WHEN
            T11.currentStatus IS NOT NULL
                AND T11.currentStatus = 'OFFER_LETTER_ISSUED'
        THEN
            'Offer letter issued'
        WHEN
            T11.currentStatus IS NOT NULL
                AND T11.currentStatus = 'OFFER_LETTER_REJECTED'
        THEN
            'Offer letter rejected'
        WHEN
            T11.currentStatus IS NOT NULL
                AND T11.currentStatus = 'OFFER_LETTER_DUE'
        THEN
            'Offer letter due'
        WHEN
            T11.currentStatus IS NOT NULL
                AND T11.currentStatus = 'ACTIVE'
        THEN
            'Active'
        WHEN
            T11.currentStatus IS NOT NULL
                AND T11.currentStatus = 'APPROVED'
        THEN
            'Approved'
        WHEN
            T11.currentStatus IS NOT NULL
                AND T11.currentStatus = 'ADMITTED'
        THEN
            'Admitted'
        WHEN
            T11.currentStatus IS NOT NULL
                AND T11.currentStatus = 'ADMITTED_ON_TRIAL'
        THEN
            'Admitted on trial'
        WHEN
            T11.currentStatus IS NOT NULL
                AND T11.currentStatus = 'ADMITTED_ON_PROVISIONAL'
        THEN
            'Admitted on provisional'
        WHEN
            T11.currentStatus IS NOT NULL
                AND T11.currentStatus = 'REJECTED'
        THEN
            'Rejected'
        WHEN
            T11.currentStatus IS NOT NULL
                AND T11.currentStatus = 'WITHDRAWN'
        THEN
            'Withdrawn'
        WHEN
            T11.currentStatus IS NOT NULL
                AND T11.currentStatus = 'WITHDRAW_AFTER_ACCEPTING_OFFER_LETTER'
        THEN
            'Withdrawn after accepting offer letter'
        WHEN
            T11.currentStatus IS NOT NULL
                AND T11.currentStatus = 'CLOSED'
        THEN
            'Closed'
        WHEN
            T11.currentStatus IS NOT NULL
                AND T11.currentStatus = 'PROVISIONAL_OFFER_ISSUED'
        THEN
            'Provisional offer issued'
            WHEN
            T11.currentStatus IS NOT NULL
                AND T11.currentStatus = 'PROVISIONAL_OFFER_REJECTED'
        THEN
            'Provisional offer rejected'
        WHEN
            T11.currentStatus IS NOT NULL
                AND T11.currentStatus = 'PROVISIONAL_OFFER_DUE'
        THEN
            'Provisional offer due'
        WHEN
            T11.currentStatus IS NOT NULL
                AND T11.currentStatus = 'OFFER_EXPIRED'
        THEN
            'Offer Expired'
            WHEN
            T11.currentStatus IS NOT NULL
                AND T11.currentStatus = 'PROVISIONAL_OFFER_EXPIRED'
        THEN
            'Provisional Offer Expired'
        ELSE ''
    END) AS OFFER_STATUS,
    DATE_FORMAT(T1.`applicationCreatedOn`, '%d-%m-%Y') AS APPLICATION_DATE,
    (Case 
    when T4.logoUrl is null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', 'emailer/images/logo_default_image.png') 
    when T4.logoUrl is null and org.orgUrl is null then 'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
    else CONCAT(org.orgUrl, '/', T4.logoUrl)end) as LOGO_URL,
    (Case when T4.headerUrl is not null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', T4.headerUrl) 
    else NULL end) as HEADER_URL,
    (Case when T4.footerUrl is not null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', T4.footerUrl) 
    else NULL end) as FOOTER_URL,
    T12.id as ACADEMY_LOCATION_ID,
    T12.academyId as ACADEMY_ID
FROM
    sg_appointment sg
        INNER JOIN
    application T1 ON T1.id = sg.applicationId
        LEFT OUTER JOIN
    application_program T11 ON T11.applicationId = T1.id
        LEFT OUTER JOIN
    academy_location T12 ON T12.id = T11.academyLocationId        
        LEFT OUTER JOIN
    prog_batch_seat_config T13 on T13.id = T11.progBatchSeatConfigId
        LEFT OUTER JOIN
    batches T14 on T14.id = T13.programBatchId
        LEFT OUTER JOIN
    programs T15 ON T15.id = T11.programId        
        LEFT JOIN
    seat_types T16 on T16.id = T13.seatTypeId
        LEFT JOIN
    applicant_person T2 ON T2.id = T1.applicantPersonId        
        LEFT JOIN
    academy_location T4 ON T4.id = T1.issuedFromAcademyLocation
        LEFT JOIN
    academy_location_addresses T5 ON T5.academyLocationId = T4.id
        LEFT JOIN
    address T6 ON T6.id = T5.addressId AND T6.addressTypeId = 10
        LEFT JOIN
    organizations org on org.id = 1
        LEFT OUTER JOIN
    city T7 ON T7.id = T6.cityId
        LEFT OUTER JOIN
    country T8 ON T8.id = T7.countryId
        LEFT OUTER JOIN
    country_region T9 ON T9.id = T7.countryRegionId
        LEFT OUTER JOIN
    users T10 ON T10.id = T1.applicationOwner
WHERE
    sg.id IN (namedParams)",'{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "code",
            "resultKey": "APPLICANT_CODE",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 3,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 2
        },
        {
            "id": 4,
            "value": "displayName",
            "resultKey": "ACADEMY_NAME_LOCATION",
            "displayCode": "",
            "displayOrder": 3
        },       
        {
            "id": 5,
            "value": "primaryeEmailId",
            "resultKey": "ACADEMY_LOCATION_EMAIL_ID",
            "displayCode": "",
            "displayOrder": 4
        },
        {
            "id": 6,
            "value": "academyName",
            "resultKey": "ACADEMY_NAME",
            "displayCode": "",
            "displayOrder": 5
        },
        {
            "id": 7,
            "value": "locationName",
            "resultKey": "LOCATION_NAME",
            "displayCode": "",
            "displayOrder": 6            
        },
        {
            "id": 8,
            "value": "programName",
            "resultKey": "PROGRAM_NAME",
            "displayCode": "",
            "displayOrder": 7
        },
        {
            "id": 9,
            "value": "batchPrintName",
            "resultKey": "BATCH_PRINT_NAME",
            "displayCode": "",
            "displayOrder": 8
        },
        {
            "id": 10,
            "value": "seatType",
            "resultKey": "SEAT_TYPE",
            "displayCode": "",
            "displayOrder": 9            
        },
        {
            "id": 11,
            "value": "applicationStatus",
            "resultKey": "APPLICATION_STATUS",
            "displayCode": "",
            "displayOrder": 10
        },
        {
            "id": 12,
            "value": "offerStatus",
            "resultKey": "OFFER_STATUS",
            "displayCode": "",
            "displayOrder": 11
        },
        {
            "id": 13,
            "value": "applicationDate",
            "resultKey": "APPLICATION_DATE",
            "displayCode": "",
            "displayOrder": 12
        },
        {
            "id": 14,
            "value": "logoURL",
            "resultKey": "LOGO_URL",
            "displayCode": "",
            "displayOrder": 13
        },
        {
            "id": 15,
            "value": "headerUrl",
            "resultKey": "HEADER_URL",
            "displayCode": "",
            "displayOrder": 14
        },
        {
            "id": 16,
            "value": "footerUrl",
            "resultKey": "FOOTER_URL",
            "displayCode": "",
            "displayOrder": 15
        },
        {
            "id": 17,
            "value": "academyLocationId",
            "resultKey": "ACADEMY_LOCATION_ID",
            "displayCode": "",
            "displayOrder": 16
        },
        {
            "id": 18,
            "value": "academyId",
            "resultKey": "ACADEMY_ID",
            "displayCode": "",
            "displayOrder": 17
        },        
        {
            "id": 19,
            "value": "appointmentDate",
            "resultKey": "APPOINTMENT_DATE",
            "displayCode": "",
            "displayOrder": 18
        },
        {
            "id": 20,
            "value": "visitTime",
            "resultKey": "VISIT_TIME",
            "displayCode": "",
            "displayOrder": 19
        }
    ]
}');


SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
SET @sysMsgEventId=(SELECT id FROM system_msg_event where code='BUZZ_APPLICANT_APPOINTMENT');

SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config);
SET @msgSubCategoryId=(SELECT id FROM `msg_category` WHERE `code`='APPOINTMENT');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='BUZZ_APPLICANT_APPOINTMENT_RECIPIENT');
SET @msgMessageTypeId=(SELECT id FROM `msg_message_type` WHERE `code`='Notifications');


INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`) 
VALUES(@msgtemplateconfigId+1,'Buzz Appointment - Applicant',@msgSubCategoryId,@sysMsgEventId,@recipientTypeId,@msgMessageTypeId,NULL,NULL,'Buzz Appointment - Applicant',NULL,'',NULL,'','APPROVED','','1','System Admin','1');


INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+1,@msgtemplateconfigId+1,'1','YOUR APPOINTMENT HAS BEEN SCHEDULED','<html>
<head>
    <title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
    <tbody>
        <tr style="background-color:#f0f0f0; height:120px;">
            <td align="center" style="margin:0px;"><img height="120" src="$recipientData[&quot;HEADER_URL&quot;]" width="100%" /></td>
        </tr>
        <tr style="background-color:#f0f0f0; line-height:20px;">
            <td style="padding:20px 20px 20px 20px;">
            <p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><strong>$recipientData[&quot;APPLICANT_CODE&quot;]</strong>-your reference for future use</p>

            <p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Dear <strong>$recipientData[&quot;FIRST_NAME&quot;] $recipientData[&quot;LAST_NAME&quot;]</strong></span></span></p>

            <p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Thank you for making an appointment with us, which has been scheduled for <strong>$recipientData[&quot;APPOINTMENT_DATE&quot;]</strong> at <strong>$recipientData[&quot;VISIT_TIME&quot;]</strong></p>
            
             <p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Please be advised that if you have not yet made your application payment or submitted an original certified copy of your ID/passport document and your latest school results and /or academic transcripts, you will need to do so in order to finalise your application.</p>
             
             <p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">If you have any questions, please contact us on <strong>$recipientData[&quot;ACADEMY_LOCATION_PHONE_NO&quot;]</strong> or <strong>$recipientData[&quot;ACADEMY_LOCATION_EMAIL_ID&quot;]</strong>, alternatively visit our website <strong>$recipientData[&quot;ACADEMY_LOCATION_URL&quot;]</strong>.</p>

            <p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;"><br/>
Kind regards, <br/><br/>
<strong>$recipientData[&quot;ACADEMY_NAME_LOCATION&quot;]</strong><br/>
$recipientData[&quot;ACADEMY_LOCATION_EMAIL_ID&quot;]<br/>
$recipientData[&quot;ACADEMY_LOCATION_PHONE_NO&quot;]<br/>
$recipientData[&quot;ACADEMY_LOCATION_URL&quot;]</span></span></p>
            </td>
        </tr>
        <tr>
            <td align="center" style="margin:0px; padding:0px;"><img height="80" width="100%" src="$recipientData[&quot;FOOTER_URL&quot;]" /></td>
        </tr>
    </tbody>
</table>
</body>
</html>');


INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES(@msgtemplateId+3,@msgtemplateconfigId+1,'2',NULL,'Thank you for making an appointment with us, which has been scheduled for $recipientData[&quot;APPOINTMENT_DATE&quot;] at $recipientData[&quot;VISIT_TIME&quot;]. Please be advised that if you have not yet made your application payment or submitted an original certified copy of your ID/passport document and your latest school results and /or academic transcripts, you will need to do so in order to finalise your application. If you have any questions, please contact us using the details below. Kind regards, $recipientData[&quot;ACADEMY_NAME_LOCATION&quot;], $recipientData[&quot;ACADEMY_LOCATION_EMAIL_ID&quot;], $recipientData[&quot;ACADEMY_LOCATION_PHONE_NO&quot;], $recipientData[&quot;ACADEMY_LOCATION_URL&quot;]');


-- End Messaging for Buzz Applicant Appointment Event 
